//                                               -*- C++ -*-
/**
 *  @file  t_NonCenteredFiniteDifferenceGradient_std.cxx
 *  @brief The test file of class NonCenteredFiniteDifferenceGradient for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_NonCenteredFiniteDifferenceGradient_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "NonCenteredFiniteDifferenceGradient.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Diff;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    NumericalScalar eps(1e-4);
    /** Instance creation */
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalPoint epsilon(myFunc.getInputDimension(), eps);
    NumericalPoint in(epsilon.getDimension(), 1.0);
    NonCenteredFiniteDifferenceGradient myGradient(epsilon, myFunc.getEvaluationImplementation());

    fullprint << "myGradient=" << myGradient << std::endl;
    fullprint << "myFunc.gradient(" << in << ")=" << myFunc.gradient(in).__repr__() << std::endl;
    fullprint << "myGradient.gradient(" << in << ")=" << myGradient.gradient(in).__repr__() << std::endl;
    /** Substitute the gradient */
    myFunc.setGradientImplementation(new NonCenteredFiniteDifferenceGradient(myGradient));
    fullprint << "myFunc.gradient(" << in << ")=" << myFunc.gradient(in).__repr__() << " (after substitution)" << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
