//                                               -*- C++ -*-
/**
 *  @file  t_Normal_wrongarg.cxx
 *  @brief The test file of class Normal with wrong arguments
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_Normal_wrongarg.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;


class TestObject : public Normal
{
public:
  explicit TestObject() : Normal(NumericalPoint(1), NumericalPoint(1), CorrelationMatrix(1)) {}
  explicit TestObject(const String & name) : Normal(NumericalPoint(1), NumericalPoint(1), CorrelationMatrix(1)) {setName(name);}
  virtual ~TestObject() {}
};


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    try {

      // Instanciate one distribution object
      NumericalPoint meanPoint(1);
      meanPoint[0] = 1.0;
      NumericalPoint sigma(1);
      sigma[0] = 1.0;
      CorrelationMatrix R(1);
      R(0, 0) = 1.0;
      Normal distribution(meanPoint, sigma, R);
      fullprint << "Distribution " << distribution << std::endl;

      // We try to set an erroneous covariance matrix (wrong dimension) into distribution
      CorrelationMatrix newR(2);
      distribution.setCorrelation(newR);

      // Normally, we should never go here
      throw TestFailed("Exception has NOT been thrown or catched !");


    }
    catch (InvalidArgumentException & ex) {
      // Nothing to do
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
