//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_composition.cxx
 *  @brief The test file of class NumericalMathFunction for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_NumericalMathFunction_composition.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <iomanip>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "ComposedNumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    /** Left hand side of the composition */
    NumericalMathFunction left("TestCompositionLeft");

    /** Right hand side of the composition */
    NumericalMathFunction right("TestCompositionRight");

    /** Compositon of left and right */
    NumericalMathFunction composed(ComposedNumericalMathFunction(left, right));

    fullprint << "right=" << right << std::endl;
    fullprint << "left=" << left << std::endl;
    fullprint << "composed=" << composed << std::endl;

    /** Does it worked? */
    NumericalPoint x(right.getInputDimension(), 1.0);
    NumericalPoint y(right(x));
    NumericalPoint z(left(y));
    Matrix Dy(right.gradient(x));
    Matrix Dz(left.gradient(y));

    fullprint << "x=" << x << " y=right(x)=" << y << " z=left(y)=" << z << std::endl;
    fullprint << "left(right(x))=" << composed(x) << std::endl;
    fullprint << "D(right)(x)=" << Dy << " D(left)(y)=" << Dz;
    fullprint << " prod=" << Dy * Dz << std::endl;
    fullprint << "D(left(right(x)))=" << composed.gradient(x) << std::endl;
    SymmetricTensor result(composed.hessian(x));
    fullprint << "DD(left(right(x)))=" << std::endl;
    for(UnsignedLong k = 0; k < result.getNbSheets(); k++)
      {
        for(UnsignedLong j = 0; j < result.getNbColumns(); j++)
          {
            for(UnsignedLong i = 0; i < result.getNbRows(); i++)
              {
                fullprint << std::setw(14) << std::scientific << std::right << result(i, j, k);
              }
            fullprint << std::endl;
          }
        fullprint << std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
