//                                               -*- C++ -*-
/**
 *  @file  t_OStream_std.cxx
 *  @brief The test file of class OStream for pretty printing of Objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (Wed, 02 May 2007) $
 *  Id:      $Id: t_Object_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OTconfig.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Object.hxx"
#include "OStream.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;

class MyTest : public Object
{
public:
  virtual String __repr__() const { return String("MyTest class"); }
  virtual String __str__(const String & offset)  const { return String("What a beautiful print !"); }
};

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream prettyprint(std::cout);

  try {
    // Test basic functionnalities
    //checkClassWithClassName<TestObject>();

    // Test some extra functionnalities
    //checkNameFeature<TestObject>();

    MyTest obj;
    std::cout << obj    << "\n";
    std::cout << true   << "\n";
    std::cout << 23     << "\n";
    std::cout << 100.23 << "\n";
    std::cout << 'z'    << "\n";
    std::cout << "ch"   << "\n";
    //std::cout << &obj   << "\n";

    OStream fullprint(std::cout);
    fullprint << obj    << "\n";
    fullprint << true   << "\n";
    fullprint << 23     << "\n";
    fullprint << 100.23 << "\n";
    fullprint << 'z'    << "\n";
    fullprint << "ch"   << "\n";
    //fullprint << &obj   << "\n";


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
