//                                               -*- C++ -*-
/**
 *  @file  t_Pairs_std.cxx
 *  @brief The test file of class Pairs for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2011-02-26 21:12:17 +0100 (sam. 26 févr. 2011) $
 *  Id:      $Id: t_Pairs_std.cxx 1813 2011-02-26 20:12:17Z lebrun $
 */
#include <iostream>
#include <sstream>
#include <cstdlib>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "CorrelationMatrix.hxx"
#include "IdentityMatrix.hxx"
#include "Graph.hxx"
#include "Pairs.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;
using namespace OT::Uncertainty::Distribution;
using namespace std;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    // Instanciate one distribution object
    UnsignedLong dim(5);
    NumericalPoint meanPoint(dim, 0.0);
    NumericalPoint sigma(dim, 5.0);
    CorrelationMatrix R(dim);

    Normal distribution(meanPoint, sigma, R);

    // Instanciate another distribution object
    for (UnsignedLong i = 1; i < dim; i++) R(i, i - 1) = -0.25;

    // Test for sampling
    UnsignedLong size = 1000;
    NumericalSample sample(distribution.getNumericalSample( size ));

    // Create an empty graph
    Graph myGraph("Pairs", " ", " ", true, "topright");

    // Create the first cloud
    Pairs myPairs(sample, "Pairs example", sample.getDescription(),"green","bullet");

    // Then, draw it
    myGraph.add(Drawable(myPairs));
    myGraph.draw("Graph_Pairs_OT");

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
