//                                               -*- C++ -*-
/**
 *  @file  t_RandomVector_function.cxx
 *  @brief The test file of composite RandomVector class
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_RandomVector_function.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "CompositeRandomVector.hxx"
#include "RandomVector.hxx"
#include "Normal.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    /* We create a NumericalMathFunction */
    NumericalMathFunction myFunction("wrapper");

    /* We create a distribution */
    UnsignedLong dim(myFunction.getInputDimension());
    CorrelationMatrix R(dim);
    for (UnsignedLong i = 0; i < dim; i++)
      {
        R(i, i) = 1.0;
        for (UnsignedLong j = 0; j < i; j++)
          {
            R(i, j) = NumericalScalar(j + 1) / dim;
          }
      }
    NumericalPoint m(dim, 1.0);
    NumericalPoint s(dim, 2.0);
    Normal distribution(m, s, R);
    const Normal & ref_distribution(distribution);
    fullprint << "distribution = " << ref_distribution << std::endl;


    /* We create a distribution-based RandomVector */
    RandomVector X(distribution);
    fullprint << "X=" << X << std::endl;
    fullprint << "is composite? " << X.isComposite() << std::endl;

    /* Check standard methods of class RandomVector */
    fullprint << "X dimension=" << X.getDimension() << std::endl;
    fullprint << "X realization (first )=" << X.getRealization() << std::endl;
    fullprint << "X realization (second)=" << X.getRealization() << std::endl;
    fullprint << "X realization (third )=" << X.getRealization() << std::endl;
    fullprint << "X sample =" << X.getNumericalSample(5) << std::endl;





    /* We create a composite RandomVector Y from X and myFunction */
    RandomVector Y(CompositeRandomVector(myFunction, X));
    fullprint << "Y=" << Y << std::endl;
    fullprint << "is composite? " << Y.isComposite() << std::endl;

    /* Check standard methods of class RandomVector */
    fullprint << "Y dimension=" << Y.getDimension() << std::endl;
    fullprint << "Y realization (first )=" << Y.getRealization() << std::endl;
    fullprint << "Y realization (second)=" << Y.getRealization() << std::endl;
    fullprint << "Y realization (third )=" << Y.getRealization() << std::endl;
    fullprint << "Y sample =" << Y.getNumericalSample(5) << std::endl;



  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
