#                                               -*- Autoconf -*-
#
#  ot_check_mpi.m4
#
#  (C) Copyright 2005-2011 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (Wed, 30 Sep 2009) $
#  Id:      $Id: ot_check_mpi.m4 1357 2009-09-30 15:51:57Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether MPI is available on the
#  build platform.
#
# OT_CHECK_MPI( [MPI_INSTALL_PATH = /usr] )
# -----------------------------------------
#
AC_DEFUN([OT_CHECK_MPI],
[
 AC_ARG_WITH([mpi],
  AC_HELP_STRING([--with-mpi@<:@=DIR@:>@], [add MPI support. @<:@]m4_default([$1], /usr)[@:>@]),
                 [withval_mpi=$withval], [withval_mpi=no])

  WITH_MPI=0

  # saving values for compilation variables
  saved_CPPFLAGS=$CPPFLAGS
  saved_LDFLAGS=$LDFLAGS
  saved_LIBS=$LIBS

  mpi_default_path=m4_default([$1], /usr)
  if ! test x${withval_mpi} = xno
  then
    # ask for MPI support
    AC_MSG_NOTICE([checking whether MPI is here and working])

    # we're trying to find the correct MPI installation path
    mpi_install_path=$mpi_default_path
    test x${withval_mpi} = xyes || mpi_install_path=$withval_mpi

    AC_MSG_CHECKING([MPI install path])
    test -d ${mpi_install_path} || AC_MSG_WARN([$mpi_install_path: incorrect path])
    AC_MSG_RESULT([$mpi_install_path])


    # we check for the MPI specific compilers
    #test x${CXX} = x && CXX=mpic++
    #test x${CC}  = x && CC=mpicc
    #test x${F77} = x && F77=mpif77
    #AC_PROG_CXX([mpic++ mpiCC])
    #AC_PROG_CC([mpicc])
    #AC_PROG_F77([mpif77])
    AC_PATH_PROGS([MPICC],[mpicc])
    AC_PATH_PROGS([MPICXX],[mpic++ mpiCC])
    AC_PATH_PROGS([MPIF77],[mpif77])

    # we test the header file presence and usability
    ${MPICXX} -showme:compile > /dev/null && flags=`${MPICXX} -showme:compile` || flags=""
    MPI_CPPFLAGS=
    for flag in ${flags}
    do
      case $flag in
      -I*) MPI_CPPFLAGS="${MPI_CPPFLAGS} $flag" ;;
      -D*) MPI_CPPFLAGS="${MPI_CPPFLAGS} $flag" ;;
      -U*) MPI_CPPFLAGS="${MPI_CPPFLAGS} $flag" ;;
      esac
    done
    MPI_CPPFLAGS="${MPI_CPPFLAGS} -DOMPI_SKIP_MPICXX"
    CPPFLAGS="${CPPFLAGS} ${MPI_CPPFLAGS}"
    AC_LANG_PUSH(C++)
    AC_CHECK_HEADERS([mpi.h],
                     [mpi_header_found=yes],
                     [mpi_header_found=no],
                     [])
    AC_LANG_POP(C++)
    test x${mpi_header_found} = xno && AC_MSG_WARN([MPI include file NOT FOUND])
    AC_SUBST(MPI_CPPFLAGS)

    # we test for the library
    MPI_LDFLAGS=
    ${MPICXX} -showme:link > /dev/null && MPI_LIBS=`${MPICXX} -showme:link` || MPI_LIBS=
    LDFLAGS="${LDFLAGS} ${MPI_LDFLAGS}"
    LIBS="${LIBS} ${MPI_LIBS}"
    AC_LANG_PUSH(C++)
    AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <mpi.h>]],
                                    [[MPI_Init( NULL, NULL ); MPI_Finalize();]])
                   ],
                   [mpi_lib_found=yes],
                   [mpi_lib_found=no])
    AC_LANG_POP(C++)
    test x${mpi_lib_found} = xno && AC_MSG_WARN([MPI library NOT FOUND])
    AC_SUBST(MPI_LDFLAGS)
    AC_SUBST(MPI_LIBS)

  fi

  if test x${mpi_header_found} = xyes && test x${mpi_lib_found} = xyes
  then
    # after all tests are successful, we support MPI
    WITH_MPI=1
    AC_MSG_NOTICE([MPI support is OK])

    # Propagate into source files
    AC_DEFINE(HAVE_MPI, [1], [Support for MPI library])

  else
    # no Mpi support
    AC_MSG_NOTICE([No MPI support])
  fi

  # Propagate test into atlocal
  AC_SUBST(WITH_MPI)

  # Propagate test into Makefiles
  AM_CONDITIONAL(WITH_MPI, test $WITH_MPI = 1)


  # restoring saved values
  CPPFLAGS=$saved_CPPFLAGS
  LDFLAGS=$saved_LDFLAGS
  LIBS=$saved_LIBS

])
