#                                               -*- Autoconf -*-
#
#  ot_check_python_packages.m4
#
#  (C) Copyright 2005-2011 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: schueller $
#  @date:   $LastChangedDate: 2011-07-29 08:12:01 +0200 (Fri, 29 Jul 2011) $
#  Id:      $Id: ot_check_python_packages.m4 2051 2011-07-29 06:12:01Z schueller $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether R has a given package
#
# OT_CHECK_PYTHON_PACKAGES( PYTHON_PACKAGE_NAME )
# -----------------------------------------------
#
AC_DEFUN([OT_CHECK_PYTHON_PACKAGES], [dnl
  AC_REQUIRE([OT_CHECK_PYTHON])
  _OT_CHECK_PYTHON_PACKAGES([$1])
  for python_package_name in $1
  do
    AC_CACHE_CHECK([whether Python has package ${python_package_name}], [ot_cv_check_python_package_${python_package_name}],
                   [eval "ot_cv_check_python_package_${python_package_name}=no"
                    ${PYTHON} -c "import ${python_package_name}" >/dev/null 2>&1 && eval "ot_cv_check_python_package_${python_package_name}=yes"])

    pkg=`echo ${python_package_name} | tr "[a-z]" "[A-Z]"`
    res=0
    eval "test x\${ot_cv_check_python_package_${python_package_name}} = xyes" && { res=1 ; PYTHON_PACKAGES="$PYTHON_PACKAGES ${python_package_name}"; }

    cmd="WITH_PYTHON_PACKAGE_${pkg}=$res"
    eval "$cmd"

    AC_SUBST(PYTHON_PACKAGES)
    AC_DEFINE_UNQUOTED(AS_TR_CPP(HAVE_PYTHON_PACKAGE_$python_package_name), [$res])
  done
])


# _OT_CHECK_PYTHON_PACKAGES( PYTHON_PACKAGE_NAME )
# ------------------------------------------------
#
m4_define([_OT_CHECK_PYTHON_PACKAGES],[dnl
  AC_FOREACH([OT_Package], [$1], 
  [AH_TEMPLATE(AS_TR_CPP(HAVE_PYTHON_PACKAGE_[]OT_Package),
               [Define to 1 if Python has package ]OT_Package[.])
  ])
])
