// SWIG file Copula.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: Copula.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "PythonWrappingFunctions.hxx"
#include "Copula.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Model::Copula>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Uncertainty::Model::Copula
  convert<_PyObject_,OpenTURNS::Uncertainty::Model::Copula>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__Copula, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::Copula * p_copula = reinterpret_cast< OpenTURNS::Uncertainty::Model::Copula * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__CopulaImplementation, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::CopulaImplementation * p_copula = reinterpret_cast< OpenTURNS::Uncertainty::Model::CopulaImplementation * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__Distribution, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::Distribution * p_dist = reinterpret_cast< OpenTURNS::Uncertainty::Model::Distribution * >( ptr );
      return *p_dist;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__DistributionImplementation, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::DistributionImplementation * p_dist = reinterpret_cast< OpenTURNS::Uncertainty::Model::DistributionImplementation * >( ptr );
      return *p_dist;

    } else if (isAPython<_PySequence_>( pyObj )) {
      check<_PySequence_>( pyObj );
      PyObject * newPyObj = PySequence_Fast( pyObj, "" );

      const UnsignedLong size = PySequence_Fast_GET_SIZE( newPyObj );
      if (size != 2) {
        throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
      }
      PyObject * elt1 = PySequence_Fast_GET_ITEM( newPyObj, 0 );
      check<_PyObject_>( elt1 );
      PyObject * elt2 = PySequence_Fast_GET_ITEM( newPyObj, 1 );
      check<_PyString_>( elt2 );
      OpenTURNS::Uncertainty::Model::Copula copula = convert<_PyObject_,OpenTURNS::Uncertainty::Model::Copula>( elt1 );
      copula.setName( convert<_PyString_,OpenTURNS::String>( elt2 ) );


      Py_XDECREF( newPyObj );
      return copula;

    } else {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither a Copula nor an object convertible to a Copula";
    }
    return OpenTURNS::Uncertainty::Model::Copula();
  }

} /* namespace OpenTURNS */

%}

%typemap(in) const Copula & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    OpenTURNS::Uncertainty::Model::CopulaImplementation * p_impl = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &p_impl, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::CopulaImplementation *"), 0))) {
      temp = OpenTURNS::Uncertainty::Model::Copula( *p_impl );
      $1 = &temp;
    } else throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object is not convertible to a distribution";
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const Copula & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, NULL, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::CopulaImplementation *"), 0));
}

%apply const Copula & { const Model::Copula &, const Uncertainty::Model::Copula &, const OpenTURNS::Uncertainty::Model::Copula & };

%include Copula.hxx
namespace OpenTURNS { namespace Uncertainty { namespace Model { %extend Copula { Copula(const Copula & other) { return new OpenTURNS::Uncertainty::Model::Copula(other); } } }}}
