// SWIG file Drawable.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: Drawable.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "Drawable.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Graph::Drawable>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Graph::Drawable
  convert<_PyObject_,OpenTURNS::Base::Graph::Drawable>(PyObject * pyObj)
  {
    check<_PyObject_>( pyObj );
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Base::Graph::DrawableImplementation *"), 0 |  0 ))) {
      OpenTURNS::Base::Graph::DrawableImplementation * p_di = reinterpret_cast< OpenTURNS::Base::Graph::DrawableImplementation * >( ptr );
      return *p_di;

    }
  }


} /* namespace OpenTURNS */

%}

%template(DrawableImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Graph::DrawableImplementation>;

%typemap(in) const OpenTURNS::Base::Graph::Drawable & {
  if (! SWIG_IsOK((SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0)))) {
    const OpenTURNS::Base::Graph::DrawableImplementation * temp;
    if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OpenTURNS__Base__Graph__DrawableImplementation, 0))) {
      return NULL;
    }
    $1 = new OpenTURNS::Base::Graph::Drawable( *temp );
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const OpenTURNS::Base::Graph::Drawable & {
  const OpenTURNS::Base::Graph::DrawableImplementation * temp;
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OpenTURNS__Base__Graph__DrawableImplementation, 0));
}

%include Drawable.hxx
namespace OpenTURNS{ namespace Base { namespace Graph {

%extend Drawable {

Drawable(const Drawable & other) { return new OpenTURNS::Base::Graph::Drawable(other); }

Drawable(PyObject * pyObj)
{
 return new OpenTURNS::Base::Graph::Drawable( OpenTURNS::convert<OpenTURNS::_PyObject_,OpenTURNS::Base::Graph::Drawable>(pyObj) );
}

}
}}}
