// SWIG file Graph.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
// Id : $Id: Graph.i 1910 2011-05-24 17:30:41Z schueller $

%{
#include "Graph.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Graph::Graph>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Graph::Graph
  convert<_PySequence_,OpenTURNS::Base::Graph::Graph>(PyObject * pyObj)
  {
    String title;
    String xTitle;
    String yTitle;
    Bool showAxes;
    String legendPosition = Base::Graph::GraphImplementation::NoSpecifiedLabel;
    NumericalScalar legendFontSize = Base::Graph::GraphImplementation::DefaultLegendFontSize;

    check<_PySequence_>( pyObj );
    PyObject * newPyObj = PySequence_Fast( pyObj, "" );

    switch (PySequence_Fast_GET_SIZE( newPyObj )) {
     case 6: { PyObject * item_5 = PySequence_Fast_GET_ITEM( newPyObj, 5 );
               check<_PyFloat_>( item_5 );
               legendFontSize = convert<_PyFloat_,NumericalScalar>( item_5 ); }
     case 5: { PyObject * item_4 = PySequence_Fast_GET_ITEM( newPyObj, 4 );
               check<_PyString_>( item_4 );
               legendPosition = convert<_PyString_,String>( item_4 ); }
     case 4: { PyObject * item_0 = PySequence_Fast_GET_ITEM( newPyObj, 0 );
               check<_PyString_>( item_0 );
               title = convert<_PyString_,String>( item_0 );
               PyObject * item_1 = PySequence_Fast_GET_ITEM( newPyObj, 1 );
               check<_PyString_>( item_1 );
               xTitle = convert<_PyString_,String>( item_1 );
               PyObject * item_2 = PySequence_Fast_GET_ITEM( newPyObj, 2 );
               check<_PyString_>( item_2 );
               yTitle = convert<_PyString_,String>( item_2 );
               PyObject * item_3 = PySequence_Fast_GET_ITEM( newPyObj, 3 );
               check<_PyBool_>( item_3 );
               showAxes = convert<_PyBool_,Bool>( item_3 ); }
             break;
     default:
      Py_XDECREF( newPyObj );
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not convertible to a Graph. Expected sequence (String, String, String, Bool, String, NumericalScalar)";
    }

    Py_XDECREF( newPyObj );
    return OpenTURNS::Base::Graph::Graph( title, xTitle, yTitle, showAxes, legendPosition, legendFontSize);
  }


} /* namespace OpenTURNS */

%}

%template(GraphImplementationTypedInterfaceObject) OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Graph::GraphImplementation>;

%template(GraphCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Graph::Graph>;

%include Graph.hxx

namespace OpenTURNS{ namespace Base { namespace Graph {

%extend Graph {

	 Graph(const Graph & other) { return new OpenTURNS::Base::Graph::Graph(*other.getImplementation()); }

Graph(PyObject * pyObj)
{
 return new OpenTURNS::Base::Graph::Graph( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Graph::Graph>(pyObj) );
}

}

}}}
