// SWIG file NumericalSample.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-29 08:12:01 +0200 (Fri, 29 Jul 2011) $
// Id : $Id: NumericalSample.i 2051 2011-07-29 06:12:01Z schueller $

%{
#include "NumericalSampleImplementation.hxx"
#include "NumericalSample.hxx"
%}

%template(NumericalSampleImplementationTypedInterfaceObject) OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Stat::NumericalSampleImplementation>;


%typemap(in) const NumericalSample & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    temp = OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::NumericalSample>( $input );
    $1 = &temp;
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const NumericalSample & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) ||
       OpenTURNS::isAPythonSequenceOf<OpenTURNS::_PySequence_>( $input );
}

%apply const NumericalSample & { const Stat::NumericalSample &, const Base::Stat::NumericalSample &, const OpenTURNS::Base::Stat::NumericalSample & };

%include NumericalSampleImplementation.hxx
%include NumericalSample.hxx
//%copyctor NumericalSample;

namespace OpenTURNS{ namespace Base { namespace Stat {
%extend NumericalSample {

	NumericalScalar __getitem__(PyObject * args) const {

          OpenTURNS::UnsignedLong arg2 ;
          OpenTURNS::UnsignedLong arg3 ;
          unsigned long val2 ;
          int ecode2 = 0 ;
          unsigned long val3 ;
          int ecode3 = 0 ;
          PyObject * obj1 = 0 ;
          PyObject * obj2 = 0 ;

          if (!PyArg_ParseTuple(args,(char *)"OO:NumericalSample___getitem__",&obj1,&obj2)) SWIG_fail;

          ecode2 = SWIG_AsVal_unsigned_SS_long(obj1, &val2);
          if (!SWIG_IsOK(ecode2)) {
            SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "NumericalSample___getitem__" "', argument " "2"" of type '" "OpenTURNS::UnsignedLong""'");
          }
          arg2 = static_cast< OpenTURNS::UnsignedLong >(val2);


          ecode3 = SWIG_AsVal_unsigned_SS_long(obj2, &val3);
          if (!SWIG_IsOK(ecode3)) {
            SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "NumericalSample___getitem__" "', argument " "3"" of type '" "OpenTURNS::UnsignedLong""'");
          }
          arg3 = static_cast< OpenTURNS::UnsignedLong >(val3);

          return (*self).at(arg2, arg3);
fail:
          return 0.;
	}



	void __setitem__(PyObject * args, NumericalScalar val) {

          OpenTURNS::UnsignedLong arg2 ;
          OpenTURNS::UnsignedLong arg3 ;
          unsigned long val2 ;
          int ecode2 = 0 ;
          unsigned long val3 ;
          int ecode3 = 0 ;
          PyObject * obj1 = 0 ;
          PyObject * obj2 = 0 ;

          if (!PyArg_ParseTuple(args,(char *)"OO:NumericalSample___setitem__",&obj1,&obj2)) SWIG_fail;

          ecode2 = SWIG_AsVal_unsigned_SS_long(obj1, &val2);
          if (!SWIG_IsOK(ecode2)) {
            SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "NumericalSample___setitem__" "', argument " "2"" of type '" "OpenTURNS::UnsignedLong""'");
          }
          arg2 = static_cast< OpenTURNS::UnsignedLong >(val2);


          ecode3 = SWIG_AsVal_unsigned_SS_long(obj2, &val3);
          if (!SWIG_IsOK(ecode3)) {
            SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "NumericalSample___setitem__" "', argument " "3"" of type '" "OpenTURNS::UnsignedLong""'");
          }
          arg3 = static_cast< OpenTURNS::UnsignedLong >(val3);
          (*self).at(arg2, arg3) = val;
fail:
	  return;
	}

//NumericalSample(const NumericalSample & other)
//{
//  return new OpenTURNS::Base::Stat::NumericalSample(other);
//}

NumericalSample(PyObject * pyObj)
{
 return new OpenTURNS::Base::Stat::NumericalSample( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::NumericalSample>(pyObj) );
}

NumericalSample(const NumericalSample & other) {
  /* Copy from implementation to avoid aliasing -> call clone(). Ticket #14 */
  return new OpenTURNS::Base::Stat::NumericalSample(*other.getImplementation());
}

} // %extend
}}}
