// SWIG file SVMKernel.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: SVMKernel.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "SVMKernel.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Algorithm::SVMKernel>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OpenTURNS::Uncertainty::Algorithm::SVMKernel
  convert<_PyObject_,OpenTURNS::Uncertainty::Algorithm::SVMKernel>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation *"), 0 |  0 )))
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an SVMKernelImplementation";
    OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * p_ki = reinterpret_cast< OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * >( ptr );
    return *p_ki;
  }

} /* namespace OpenTURNS */


%}

%template(SVMKernelImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation>;

%typemap(in) const OpenTURNS::Uncertainty::Algorithm::SVMKernel & {
  if (! SWIG_IsOK((SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0)))) {
    const OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * temp;
    if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OpenTURNS__Uncertainty__Algorithm__SVMKernelImplementation, 0))) {
      return NULL;
    }
    $1 = new OpenTURNS::Uncertainty::Algorithm::SVMKernel( *temp );
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const OpenTURNS::Uncertainty::Algorithm::SVMKernel & {
  const OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * temp;
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OpenTURNS__Uncertainty__Algorithm__SVMKernelImplementation, 0));
}

%include SVMKernel.hxx
namespace OpenTURNS{ namespace Uncertainty { namespace Algorithm {

%extend SVMKernel {

SVMKernel(const SVMKernel & other) { return new OpenTURNS::Uncertainty::Algorithm::SVMKernel(other); }

}
}}}
