// SWIG file simulation_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: simulation_module.i 1991 2011-07-06 10:03:57Z schueller $

%module(package="openturns", docstring="Simulation uncertainty propagation algo_module.ithms.") simulation
#pragma SWIG nowarn=302,509
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTBase.hxx"
#include "OTModel.hxx"
#include "OTDistribution.hxx"
#include "OTIsoProbabilisticTransformation.hxx"
#include "OTAnalytical.hxx"
#include "OTSimulation.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import common_module.i
%include TestResult.i
%import base_module.i

/* Uncertainty/Model */
/* Uncertainty/Distribution */
%import model_copula_module.i
%import UncertaintyModelCopulaTemplateDefs.i

/* Uncertainty/Algorithm/IsoProbabilisticTransformation */
%import isoprobabilistictransformation_module.i
%import UncertaintyIsoProbabilisticTransformationTemplateDefs.i

/* Uncertainty/Algorithm/Analytical */
%import analytical_module.i
%import UncertaintyAnalyticalTemplateDefs.i

/* Uncertainty/Algorithm/Simulation */
%include SimulationResultImplementation.i
%include SimulationResult.i
%include Simulation.i
%include PostAnalyticalSimulation.i
%include Wilks.i
%include MonteCarlo.i
%include LHS.i
%include ImportanceSampling.i
%include PostAnalyticalControlledImportanceSampling.i
%include PostAnalyticalImportanceSampling.i
%include RootStrategyImplementation.i
%include RootStrategy.i
%include SamplingStrategyImplementation.i
%include SamplingStrategy.i
%include DirectionalSampling.i
%include OrthogonalDirection.i
%include RandomDirection.i
%include MediumSafe.i
%include RiskyAndFast.i
%include SafeAndSlow.i
%include QuasiMonteCarlo.i
%include QuasiMonteCarloResult.i

/* At last we include template definitions */
%include UncertaintySimulationTemplateDefs.i
