// SWIG file statistics_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-29 08:12:01 +0200 (Fri, 29 Jul 2011) $
// Id : $Id: statistics_module.i 2051 2011-07-29 06:12:01Z schueller $

%module(package="openturns", docstring="Statistical classes.") statistics
%feature("autodoc","1");

%pythoncode %{
def getCorrelationMatrixFromMap(Vars,Map):
  """
  getCorrelationMatrixFromMap(Vars,Map) transform a two-dimension dict whose keys
  are listed in Vars into a CorrelationMatrix. The values are numerical.
  No need to define all the elements in the map since CorrelationMatrix is symmetric.
  Example:
    Vars=['X','Y','Z']
    Map={}
    Map['X']={}
    Map['X']['Y']= 0.1
    Map['X']['Z']= 0.7
    Map['Y']={}
    Map['Y']['Z']= 0.8
    R = getCorrelationMatrixFromMap(Vars,Map)
  """
  Corr = CorrelationMatrix( len(Vars) )
  i=0
  for first in Vars:
    j=0
    for second in Vars:
      if Map.has_key(first) and Map[first].has_key(second):
        Corr[i,j] = Map[first][second]
      j+=1
    i+=1
  return Corr
%}


%{
#include "OTconfig.hxx"
#include "OTCommon.hxx"
#include "OTType.hxx"
#include "OTStat.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import typ_module.i
%import BaseTypTemplateDefs.i

/* Base/Stat */
%include CovarianceMatrix.i
%include CorrelationMatrix.i
%include IdentityMatrix.i
%include NumericalSample.i
%include HistoryStrategyImplementation.i
%include HistoryStrategy.i
%include Compact.i
%include Full.i
%include Last.i
%include Null.i
%include ConfidenceInterval.i
%include LinearModel.i
%include LinearModelFactory.i
%include TestResult.i
%include RandomGenerator.i
%include LowDiscrepancySequenceImplementation.i
%include LowDiscrepancySequence.i
%include SobolSequence.i
%include FaureSequence.i
%include HaltonSequence.i
%include InverseHaltonSequence.i
%include SobolIndicesParameters.i
%include SobolIndicesResult.i
%include CorrelationAnalysis.i
%include SensitivityAnalysis.i


/* At last we include template definitions */
%include BaseStatisticsTemplateDefs.i
