//                                               -*- C++ -*-
/**
 *  @file  DynamicalFunction.cxx
 *  @brief Abstract top-level class for all distributions
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (mar. 24 mai 2011) $
 *  Id:      $Id: DynamicalFunction.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include "DynamicalFunction.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(DynamicalFunction);

/* Default constructor */
DynamicalFunction::DynamicalFunction()
  : TypedInterfaceObject<DynamicalFunctionImplementation>(new DynamicalFunctionImplementation())
{
  // Nothing to do
}

/* Constructor from DynamicalFunctionImplementation */
DynamicalFunction::DynamicalFunction(const DynamicalFunctionImplementation & implementation)
  : TypedInterfaceObject<DynamicalFunctionImplementation>(implementation.clone())
{
  // Nothing to do
}

/* Constructor from implementation */
DynamicalFunction::DynamicalFunction(const Implementation & p_implementation)
  : TypedInterfaceObject<DynamicalFunctionImplementation>(p_implementation)
{
  // Nothing to do
}

/* Constructor from implementation pointer */
DynamicalFunction::DynamicalFunction(DynamicalFunctionImplementation * p_implementation)
  : TypedInterfaceObject<DynamicalFunctionImplementation>(p_implementation)
{
  // Nothing to do
}

/* Comparison operator */
Bool DynamicalFunction::operator ==(const DynamicalFunction & other) const
{
  return true;
}

/* String converter */
String DynamicalFunction::__repr__() const {
  return OSS() << "class=" << DynamicalFunction::GetClassName()
               << " name=" << getName()
               << " implementation=" << getImplementation()->__repr__();
}

/* String converter */
String DynamicalFunction::__str__(const String & offset) const
{
  const String name(getName());
  OSS oss(false);
  oss << offset;
  if (name.size() > 0) oss << "DynamicalFunction '" << name << "'";
  oss << "\n" << getImplementation()->__str__( offset + "  " );
  return oss;
}

/* Get the i-th marginal function */
DynamicalFunction DynamicalFunction::getMarginal(const UnsignedLong i) const
{
  return *(getImplementation()->getMarginal(i));
}

/* Get the function corresponding to indices components */
DynamicalFunction DynamicalFunction::getMarginal(const Indices & indices) const
{
  return *(getImplementation()->getMarginal(indices));
}

/* Input description Accessor */
Description DynamicalFunction::getInputDescription() const
{
  return getImplementation()->getInputDescription();
}

/* Output description Accessor */
Description DynamicalFunction::getOutputDescription() const
{
  return getImplementation()->getOutputDescription();
}

/* Operator () */
TimeSeries DynamicalFunction::operator() (const TimeSeries & inTS) const
{
  return getImplementation()->operator()(inTS);
}

/* Operator () */
ProcessSample DynamicalFunction::operator() (const ProcessSample & inPS) const
{
  return getImplementation()->operator()(inPS);
}

/* Accessor for input point dimension */
UnsignedLong DynamicalFunction::getInputDimension() const
{
  return getImplementation()->getInputDimension();
}

/* Accessor for output point dimension */
UnsignedLong DynamicalFunction::getOutputDimension() const
{
  return getImplementation()->getOutputDimension();
}

/* Number of calls to the dynamical function */
UnsignedLong DynamicalFunction::getCallsNumber() const
{
  return getImplementation()->getCallsNumber();
}

END_NAMESPACE_OPENTURNS
