//                                               -*- C++ -*-
/**
 *  @file  LARFSZero.cxx
 *  @brief A factory for building BasisSequence objects
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LARFSZero.hxx 1649 2010-11-09 12:44:00Z dutka $
 */

#include "BasisSequenceFactoryImplementation.hxx"
#include "LARFSZero.hxx"
#include "Exception.hxx"

BEGIN_NAMESPACE_OPENTURNS




/* Default constructor */
LARFSZero::LARFSZero(const Bool verbose)
  : BasisSequenceFactoryImplementation(verbose)
{
  // Nothing to do
}

/* Virtual constructor */
LARFSZero * LARFSZero::clone() const
{
  return new LARFSZero( *this );
}

/* Method to create new BasisSequence objects */
BasisSequence LARFSZero::build(const NumericalSample & x,
                               const NumericalSample & y,
                               const Basis & psi) const
{
  throw NotYetImplementedException(HERE);
  return BasisSequence( psi );
}

/* String converter */
String LARFSZero::__repr__() const
{
  return "class=LARFSZero";
}

String LARFSZero::__str__(const String & offset) const
{
  return __repr__();
}

/* Method save() stores the object through the StorageManager */
void LARFSZero::save(Advocate & adv) const
{
  BasisSequenceFactoryImplementation::save(adv);
}

/* Method load() reloads the object from the StorageManager */
void LARFSZero::load(Advocate & adv)
{
  BasisSequenceFactoryImplementation::load(adv);
}


END_NAMESPACE_OPENTURNS
