//                                               -*- C++ -*-
/**
 *  @file  AbdoRackwitz.hxx
 *  @brief AbdoRackwitz is an actual implementation for
 *         NearestPointAlgorithm using the AbdoRackwitz algorithm.
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: AbdoRackwitz.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_ABDORACKWITZ_HXX
#define OPENTURNS_ABDORACKWITZ_HXX

#include "OTprivate.hxx"
#include "NearestPointAlgorithmImplementation.hxx"
#include "NumericalPoint.hxx"
#include "AbdoRackwitzSpecificParameters.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class AbdoRackwitz
 * AbdoRackwitz is an actual implementation for
 * NearestPointAlgorithm
 */
class AbdoRackwitz :
  public NearestPointAlgorithmImplementation
{
  CLASSNAME;
public:


  /** Default constructor */
  AbdoRackwitz();

  /** Constructor with parameters */
  AbdoRackwitz(const AbdoRackwitzSpecificParameters & specificParameters,
               const NumericalMathFunction & levelFunction);


  /** Virtual constructor */
  virtual AbdoRackwitz * clone() const;

  /** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
  void run();

  /** Specific parameters accessor */
  AbdoRackwitzSpecificParameters getSpecificParameters() const;

  /** Specific parameters accessor */
  void setSpecificParameters(const AbdoRackwitzSpecificParameters & specificParameters);

  /** String converter */
  String __repr__() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

private:

  /** Perform a line search in the given direction */
  NumericalScalar computeLineSearch();

  /** Initialize internal state */
  void initialize();

  /** Abdo Rackwitz specific parameters */
  AbdoRackwitzSpecificParameters specificParameters_;

  /** Abdo Rackwitz current penalization factor */
  NumericalScalar currentSigma_;

  /** Abdo Rackwitz current point */
  NumericalPoint currentPoint_;

  /** Abdo Rackwitz current direction */
  NumericalPoint currentDirection_;

  /** Abdo Rackwitz current level value */
  NumericalScalar currentLevelValue_;

  /** Abdo Rackwitz current gradient as a column vector */
  NumericalPoint currentGradient_;

  /** Abdo Rackwitz current Lagrange multiplier */
  NumericalScalar currentLambda_;

}; /* class AbdoRackwitz */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_ABDORACKWITZ_HXX */
