//                                               -*- C++ -*-
/**
 *  @file  Brent.hxx
 *  @brief Implementation class of the scalar nonlinear solver based on
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Brent.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_BRENT_HXX
#define OPENTURNS_BRENT_HXX

#include "OTprivate.hxx"
#include "SolverImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS




/*
 * @class Brent
 *
 * This class is an interface for the 1D nonlinear solverImplementations
 */
class Brent : public SolverImplementation
{
  CLASSNAME;
public:


  /* Default constructor */
  explicit Brent();

  /* Parameter constructor */
  explicit Brent(const NumericalScalar absoluteError,
                 const NumericalScalar relativeError,
                 const UnsignedLong maximumFunctionEvaluation);


  /* Copy constructor */

  /* Virtual constructor */
  virtual Brent * clone() const;

  /* String converter */
  String __repr__() const;

  /* Solve attempt to find one root to the equation function(x) = value in [infPoint, supPoint] given function(infPoint) and function(supPoint) with the Brent method */
  using SolverImplementation::solve;
  NumericalScalar solve(const NumericalMathFunction & function,
                        const NumericalScalar value,
                        const NumericalScalar infPoint,
                        const NumericalScalar supPoint,
                        const NumericalScalar infValue,
                        const NumericalScalar supValue);

private:

}; /* Class Brent */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BRENT_HXX */
