//                                               -*- C++ -*-
/**
 *  @file  DomainImplementation.cxx
 *  @brief DomainImplementation is defined as a domain of \mathbb{R}^d
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: DomainImplementation.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "DomainImplementation.hxx"
#include "PersistentObjectFactory.hxx"
#include "Os.hxx"
#include "Exception.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(DomainImplementation);

static Factory<DomainImplementation> RegisteredFactory("DomainImplementation");


/* Default constructor */
DomainImplementation::DomainImplementation(UnsignedLong dimension):
  PersistentObject(),
  dimension_(dimension)
{
  // Nothing to do
}

/* Clone method */
DomainImplementation * DomainImplementation::clone() const
{
  return new DomainImplementation(*this);
}

/* String converter */
String DomainImplementation::__repr__() const
{
  return OSS() << "class = " << GetClassName()
               << " name = " << getName()
               << " dimension = " << dimension_;

}

String DomainImplementation::__str__(const String & offset) const
{
  return OSS () << offset << __repr__();
}

/* Check if the given point is inside of the closed interval */
Bool DomainImplementation::contains(const NumericalPoint & point) const
{
  throw NotYetImplementedException(HERE);
}

/**/
UnsignedLong DomainImplementation::getDimension() const
{
  return dimension_;
}

/* Method save() stores the object through the StorageManager */
void DomainImplementation::save(Advocate & adv) const
{
  PersistentObject::save(adv);
  adv.saveAttribute("dimension_", dimension_);
}

/* Method load() reloads the object from the StorageManager */
void DomainImplementation::load(Advocate & adv)
{
  PersistentObject::load(adv);
  adv.loadAttribute("dimension_", dimension_);
}

} /* Namespace OpenTURNS */
