//                                               -*- C++ -*-
/**
 *  @file  FORM.cxx
 *  @brief FORM implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: FORM.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "FORM.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(FORM);

static Factory< FORM > RegisteredFactory("FORM");

/* Default constructor for the save/load mechanism */
FORM::FORM()
  : Analytical(),
    formResult_()
{
  // Nothing to do
}

/*
 * @brief  Standard constructor: the class is defined by an optimisation algorithm, a failure event and a physical starting point
 */
FORM::FORM(const NearestPointAlgorithm & nearestPointAlgorithm,
           const Event & event,
           const NumericalPoint & physicalStartingPoint):
  Analytical(nearestPointAlgorithm, event, physicalStartingPoint)
{
  // Nothing to do
}

/* Virtual constructor */
FORM * FORM::clone() const
{
  return new FORM(*this);
}

/* Result accessor */
FORMResult FORM::getResult() const
{
  return formResult_;
}

/* Result accessor */
void FORM::setResult(const FORMResult & formResult)
{
  formResult_ = formResult;
}


/* String converter */
String FORM::__repr__() const
{
  OSS oss;
  oss << "class=" << FORM::GetClassName()
      << " " << Analytical::__repr__()
      << " result=" << formResult_;
  return oss;
}

/* Function that computes the design point by re-using the Analytical::run() and creates a FORMResult */
void FORM::run()
{
  Analytical::run();
  formResult_ = FORMResult(Analytical::getAnalyticalResult().getStandardSpaceDesignPoint(), Analytical::getAnalyticalResult().getLimitStateVariable(), Analytical::getAnalyticalResult().getIsStandardPointOriginInFailureSpace());
}

/* Method save() stores the object through the StorageManager */
void FORM::save(Advocate & adv) const
{

  Analytical::save(adv);
  adv.saveAttribute("formResult_", formResult_);
}

/* Method load() reloads the object from the StorageManager */
void FORM::load(Advocate & adv)
{
  Analytical::load(adv);
  adv.loadAttribute("formResult_", formResult_);
}

END_NAMESPACE_OPENTURNS
