//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategy.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-28 00:59:04 +0200 (Wed, 28 Mar 2012) $
 *  Id:      $Id: SamplingStrategy.cxx 2435 2012-03-27 22:59:04Z lebrun $
 */
#include "SamplingStrategy.hxx"
#include "RandomDirection.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class SamplingStrategy
 */

CLASSNAMEINIT(SamplingStrategy);

/* Defaultonstructor */
SamplingStrategy::SamplingStrategy()
  : TypedInterfaceObject<SamplingStrategyImplementation>(RandomDirection().clone())
{
  // Nothing to do
}

/* Constructor with parameters */
SamplingStrategy::SamplingStrategy(Implementation & p_implementation)
  : TypedInterfaceObject<SamplingStrategyImplementation>(p_implementation)
{
  // Nothing to do
}

/* Constructor with parameters */
SamplingStrategy::SamplingStrategy(const SamplingStrategyImplementation & implementation)
  : TypedInterfaceObject<SamplingStrategyImplementation>(implementation.clone())
{
  // Nothing to do
}

/* Constructor with parameters */
SamplingStrategy::SamplingStrategy(const UnsignedLong dimension)
  : TypedInterfaceObject<SamplingStrategyImplementation>(new RandomDirection(dimension))
{
  // Nothing to do
}

/* Generate a set of directions */
NumericalSample SamplingStrategy::generate() const
{
  return getImplementation()->generate();
}

/* Dimension accessor */
void SamplingStrategy::setDimension(const UnsignedLong dimension)
{
  copyOnWrite();
  getImplementation()->setDimension(dimension);
}

UnsignedLong SamplingStrategy::getDimension() const
{
  return getImplementation()->getDimension();
}

/* String converter */
String SamplingStrategy::__repr__() const
{
  OSS oss;
  oss << "class=" << SamplingStrategy::GetClassName()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}

END_NAMESPACE_OPENTURNS
