//                                               -*- C++ -*-
/**
 *  @file  InverseNormalFactory.hxx
 *  @brief Factory for InverseNormal distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (lun. 11 avril 2011) $
 *  Id:      $Id: InverseNormalFactory.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_INVERSENORMALFACTORY_HXX
#define OPENTURNS_INVERSENORMALFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "InverseNormal.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class InverseNormalFactory
 */
class InverseNormalFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  InverseNormalFactory();

  /** Virtual constructor */
  virtual InverseNormalFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  InverseNormal * build(const NumericalSample & sample) const;
  InverseNormal * build(const NumericalPointCollection & parameters) const;
  InverseNormal * build() const;


}; /* class InverseNormalFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_INVERSENORMALFACTORY_HXX */
