//                                               -*- C++ -*-
/**
 *  @file  UserDefinedPair.hxx
 *  @brief The UserDefinedPair class.
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2010-11-21 19:45:57 +0100 (dim. 21 nov. 2010) $
 *  Id:      $Id: UserDefinedPair.hxx 1657 2010-11-21 18:45:57Z lebrun $
 */
#ifndef OPENTURNS_USERDEFINEDPAIR_HXX
#define OPENTURNS_USERDEFINEDPAIR_HXX

#include "OTprivate.hxx"
#include "NumericalPoint.hxx"
#include "StorageManager.hxx"
#include "PersistentObject.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class UserDefinedPair
 *
 * The UserDefinedPair class.
 */
class UserDefinedPair
  : public PersistentObject
{
  CLASSNAME;
public:

  UserDefinedPair();
  UserDefinedPair(const NumericalPoint & x,
                  const NumericalScalar p);

  virtual UserDefinedPair * clone() const;

  Bool operator == (const UserDefinedPair & other) const;

  void setX(const NumericalPoint & x);

  void setP(const NumericalScalar p);

  NumericalPoint getX() const;

  NumericalScalar getP() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

  virtual String __repr__() const;

private:

  /** Position of the modality */
  NumericalPoint x_;
  /** Probability of the modality */
  NumericalScalar p_;

}; /* end class UserDefinedPair */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_USERDEFINEDPAIR_HXX */
