//                                               -*- C++ -*-
/**
 *  @file  LinearModelTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-07 15:30:42 +0100 (Wed, 07 Mar 2012) $
 *  Id:      $Id: LinearModelTest.hxx 2411 2012-03-07 14:30:42Z lebrun $
 */
#ifndef OPENTURNS_LINEARMODELTEST_HXX
#define OPENTURNS_LINEARMODELTEST_HXX

#include "OTprivate.hxx"
#include "TestResult.hxx"
#include "NumericalSample.hxx"
#include "LinearModel.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class LinearModelTest
 *
 */

class LinearModelTest
{
public:


  /** Default constructor */
  LinearModelTest();

  /**  */
  static TestResult LinearModelAdjustedRSquared(const NumericalSample & firstSample,
                                                const NumericalSample & secondSample,
                                                const LinearModel & linearModel,
                                                const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelAdjustedRSquared(const NumericalSample & firstSample,
                                                const NumericalSample & secondSample,
                                                const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelFisher(const NumericalSample & firstSample,
                                      const NumericalSample & secondSample,
                                      const LinearModel & linearModel,
                                      const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelFisher(const NumericalSample & firstSample,
                                      const NumericalSample & secondSample,
                                      const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelResidualMean(const NumericalSample & firstSample,
                                            const NumericalSample & secondSample,
                                            const LinearModel & linearModel,
                                            const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelResidualMean(const NumericalSample & firstSample,
                                            const NumericalSample & secondSample,
                                            const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelRSquared(const NumericalSample & firstSample,
                                        const NumericalSample & secondSample,
                                        const LinearModel & linearModel,
                                        const NumericalScalar level=0.95);

  /**  */
  static TestResult LinearModelRSquared(const NumericalSample & firstSample,
                                        const NumericalSample & secondSample,
                                        const NumericalScalar level=0.95);

protected:
  /** Generic invocation of a R script for testing a distribution against a sample */
  static TestResult RunTwoSamplesALinearModelRTest(const NumericalSample & firstSample,
                                                   const NumericalSample & secondSample,
                                                   const LinearModel & linearModel,
                                                   const NumericalScalar level,
                                                   const String & testName);

}; /* class LinearModelTest */

END_NAMESPACE_OPENTURNS
#endif /* OPENTURNS_LINEARMODELTEST_HXX */
