//                                               -*- C++ -*-
/**
 *  @file  t_ConstantNumericalMathGradientImplementation_std.cxx
 *  @brief The test file of class ConstantNumericalMathGradientImplementation for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_ConstantNumericalMathGradientImplementation_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "ConstantNumericalMathGradientImplementation.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    UnsignedLong inputDimension(3);
    UnsignedLong outputDimension(2);
    // Constant term
    Matrix constant(inputDimension, outputDimension);
    constant(0,0) = 1.0;
    constant(1,0) = 2.0;
    constant(2,0) = 5.0;
    constant(0,1) = 7.0;
    constant(1,1) = 9.0;
    constant(2,1) = 3.0;

    ConstantNumericalMathGradientImplementation myGradient(constant);
    myGradient.setName("constantGradient");
    NumericalPoint inPoint(inputDimension);
    inPoint[0] = 7.0;
    inPoint[1] = 8.0;
    inPoint[2] = 9.0;
    Matrix outMatrix = myGradient.gradient( inPoint );
    fullprint << "myGradient=" << myGradient << std::endl;
    fullprint << myGradient.getName() << "( " << inPoint << " ) = " << outMatrix << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
