//                                               -*- C++ -*-
/**
 *  @file  t_Triangular_std.cxx
 *  @brief The test file of class Triangular for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_FiniteDifferenceStep_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    UnsignedLong dimension( 2 );
    NumericalPoint epsilon( dimension, 1e-5 );
    NumericalPoint eta( dimension, 1.0 );
    Collection<FiniteDifferenceStep> coll;
    coll.add(ConstantStep(epsilon));
    coll.add(BlendedStep(epsilon, eta));


    NumericalPoint x(dimension, -3.0);

    for (UnsignedLong i = 0; i < coll.getSize(); ++ i)
      {
        FiniteDifferenceStep step_i( coll[i] );
        std::cout << "step type=" << step_i.getImplementation()->getClassName()<<" x="<<x<<" epsilon="<<step_i.getEpsilon()<<" step value="<<step_i.operator()(x) << std::endl;
      }


    FiniteDifferenceStep step( NumericalPoint(3, 1e-4) );

    fullprint << "saved  FiniteDifferenceStep=" << step << std::endl;

    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("step", step);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    Triangular triangular;
    myStudy2.fillObject("step", step);
    fullprint << "loaded FiniteDifferenceStep=" << step << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
