//                                               -*- C++ -*-
/**
 *  @file  t_TrapezoidalFactory_std.cxx
 *  @brief The test file of class Trapezoidal for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (mer. 30 sept. 2009) $
 *  Id:      $Id: t_TrapezoidalFactory_std.cxx 1357 2009-09-30 15:51:57Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "TrapezoidalFactory.hxx"
#include "Trapezoidal.hxx"
#include "Distribution.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    Trapezoidal distribution( 1.0, 2.3, 4.5, 5.0 );
    UnsignedLong size(10000);
    NumericalSample sample(distribution.getNumericalSample(size));
    TrapezoidalFactory factory;
    Distribution estimatedDistribution(factory.build(sample));
    fullprint << "Distribution          =" << distribution << std::endl;
    int oldPrecision = PlatformInfo::GetNumericalPrecision();
    PlatformInfo::SetNumericalPrecision( 4 );
    fullprint << "Estimated distribution=" << estimatedDistribution << std::endl;
    PlatformInfo::SetNumericalPrecision( oldPrecision );
    estimatedDistribution = factory.build();
    fullprint << "Default distribution=" << estimatedDistribution << std::endl;
    estimatedDistribution = factory.build(distribution.getParametersCollection());
    fullprint << "Distribution from parameters=" << estimatedDistribution << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
