#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    distribution = Multinomial(5, NumericalPoint(3, 0.25))
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = MultinomialFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)

except :
  import sys
  print "t_MultinomialFactory.py", sys.exc_type, sys.exc_value
