#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    dim = 3
    R = CorrelationMatrix(dim)
    for i in range(dim) :
        for j in range(i) :
	    R[i, j] = 0.5 * (1.0 + i) / dim
    distribution = NormalCopula(R)
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = NormalCopulaFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", distribution
    print "Estimated distribution=", estimatedDistribution

except :
  import sys
  print "t_NormalFactory.py", sys.exc_type, sys.exc_value
