"computeTestRegression" <-
function(outSample, inSample, testLevel = 0.95) {

  # Perform lm on the dataset.
  lmSummary <- summary(lm(outSample ~ inSample))

  # The p-values are accessible via summary()
  pValues <- lmSummary$coefficients[,4]
  names(pValues) <- NULL
  
  testResult <- ifelse(pValues > 1 - testLevel, 1, 0)
  return(list(test = "",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = pValues))

}

