/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#ifndef _NESSUS_NESSUSLIB_H
#define _NESSUS_NESSUSLIB_H
 

#ifndef ExtFunc
#define ExtFunc
#endif

ExtFunc void nessus_lib_version(int *, int *, int *);
 
/*
 * Arglist definition and defines
 */
 
struct arglist {
	char * name;
	int type;
	void * value;
	long length;
	struct arglist * next;
	int hash;
	};

	
#define ARG_STRING 	1
#define ARG_PTR 	2
#define ARG_INT 	3
#define ARG_ARGLIST 	4
#define ARG_STRUCT	5





/*
 * Plugin standard function templates
 */

typedef int(*plugin_init_t)(struct arglist *);
typedef int(*plugin_run_t)(struct arglist *);      





/*
 * Network-related functions
 */

/* Plugin specific network functions */
ExtFunc int open_sock_tcp(struct arglist * , unsigned int, int );
ExtFunc int open_sock_udp(struct arglist * , unsigned int );
ExtFunc int open_sock_option(struct arglist * , unsigned int , int , int, int);
ExtFunc int recv_line(int, char *, size_t);
ExtFunc int nrecv(int, void*, int, int);
ExtFunc int socket_close(int);

/* Additional functions -- should not be used by the plugins */
ExtFunc int open_sock_tcp_hn(const char * , unsigned int );
ExtFunc int open_sock_opt_hn(const char * , unsigned int , int , int, int );
ExtFunc struct in_addr nn_resolve (const char *); 

#ifdef __GNUC__
ExtFunc void auth_printf(struct arglist *, char * , ...) __attribute__ (( format (printf, 2, 3)));
#else
ExtFunc void auth_printf(struct arglist *, char * , ...);
#endif
ExtFunc void scanner_add_port(struct arglist*, int, char *);
ExtFunc void auth_send(struct arglist *, char *);
ExtFunc char * auth_gets(struct arglist *, char * , size_t);
ExtFunc int ping_host(struct in_addr);

ExtFunc unsigned short *getpts(char *, int *);

/* 
 * Management of the arglists --should not be used directly by
 * the plugins
 */

ExtFunc void arg_add_value(struct arglist *, const char *, int, long, void *);	   
ExtFunc void arg_add_value_at_head(struct arglist *, const char *, int, long, void *);	   
ExtFunc int arg_set_value(struct arglist *, const char *, long, void *);	
ExtFunc int arg_set_type(struct arglist *, const char *, int);
ExtFunc void * arg_get_value(struct arglist *, const char *);
ExtFunc int arg_get_type(struct arglist *, const char *);
ExtFunc int arg_get_length(struct arglist *, const char *);
ExtFunc void arg_dump(struct arglist *, int);
ExtFunc void arg_dup(struct arglist *, struct arglist *);
ExtFunc void arg_free(struct arglist *);
ExtFunc void arg_free_all(struct arglist *);
ExtFunc void arg_free_name(char*);


ExtFunc char * cache_inc(const char * );
ExtFunc void   cache_dec(const char * );



ExtFunc void plug_set_ssl_cert(struct arglist*, char*);
ExtFunc void plug_set_ssl_key(struct arglist*, char*);
ExtFunc void plug_set_ssl_pem_password(struct arglist*, char*);
ExtFunc int nessus_SSL_init(char*);
ExtFunc void sslerror(char*);
ExtFunc void nessus_install_passwd_cb(SSL_CTX*, char*);





 




/*
 * Replacement for system related functions
 */
 


ExtFunc void * emalloc(size_t);
ExtFunc char * estrdup(const char *);
ExtFunc void * erealloc(void*, size_t);
ExtFunc void efree(void *);
ExtFunc size_t estrlen(const char *, size_t);


ExtFunc char* addslashes(char*);
ExtFunc char* rmslashes(char*);



/* 
 * Misc. defines
 */
/* Actions types of the plugins */
#define ACT_LAST		ACT_END
#define ACT_FIRST		ACT_INIT

#define ACT_END			10
#define ACT_FLOOD		9
#define ACT_KILL_HOST		8
#define ACT_DENIAL 		7
#define ACT_DESTRUCTIVE_ATTACK 	6
#define ACT_MIXED_ATTACK 	5
#define ACT_ATTACK 		4
#define ACT_GATHER_INFO 	3
#define ACT_SETTINGS		2
#define ACT_SCANNER 		1
#define ACT_INIT		0


#define LAUNCH_DISABLED 0
#define LAUNCH_RUN      1
#define LAUNCH_SILENT   2




/*
 * Type of "transport layer", for encapsulated connections
 * Only SSL is supported at this time.
 * (Bad) examples of other layers could be SOCKS, httptunnel, icmptunnel,
 * RMI over HTTP, DCOM over HTTP, TCP over TCP, etc.
 */
#define NESSUS_ENCAPS_IP	1
#define NESSUS_ENCAPS_SSLv23	2 /* Ask for compatibility options */
#define NESSUS_ENCAPS_SSLv2	3
#define NESSUS_ENCAPS_SSLv3	4
#define NESSUS_ENCAPS_TLSv1	5
#define NESSUS_ENCAPS_TLSv10	NESSUS_ENCAPS_TLSv1
#define NESSUS_ENCAPS_TLSv11	6

#define IS_ENCAPS_SSL(x) ((x) >= NESSUS_ENCAPS_SSLv23 && (x) <= NESSUS_ENCAPS_TLSv11)




ExtFunc int    open_stream_connection(struct arglist *, unsigned int, int, int);
ExtFunc int    open_stream_connection_unknown_encaps(struct arglist *, unsigned int, int, int *);
ExtFunc int    open_stream_connection_unknown_encaps5(struct arglist *, unsigned int, int, int *, int *);
ExtFunc int    open_stream_auto_encaps(struct arglist *, unsigned int, int);
ExtFunc int    write_stream_connection (int, void * buf, int n);
ExtFunc int    read_stream_connection (int, void *, int);
ExtFunc int    read_stream_connection_min(int, void*, int, int);
ExtFunc int    close_stream_connection(int);
ExtFunc int    nsend(int, void*, int, int);
ExtFunc const char* get_encaps_name(int);
ExtFunc const char* get_encaps_through(int);

ExtFunc int    stream_set_timeout(int, int);
ExtFunc int    stream_set_options(int, int, int);

ExtFunc int	stream_set_buffer(int, int);
ExtFunc int	stream_get_buffer_sz (int);

ExtFunc int 	stream_pending(int);

ExtFunc        X509*   stream_get_server_certificate(int);
ExtFunc	       char*   stream_get_ascii_server_certificate(int);




ExtFunc int nessus_register_connection(int, SSL*);
ExtFunc int nessus_deregister_connection(int);
ExtFunc int nessus_get_socket_from_connection(int);


ExtFunc void nessus_init_random();

ExtFunc int stream_zero(fd_set*);
ExtFunc int stream_set(int, fd_set*);
ExtFunc int stream_isset(int, fd_set*);

int os_send(int, void*, int, int);
int os_recv(int, void*, int, int);


int fd_is_stream(int);


#endif

