##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from common import generate_script

class GenerateScriptTestCase(unittest.TestCase):

    ## Initial Set UP
    generate_obj = generate_script.GenerateCode()
    gen_nvt_obj = generate_script.GenerateNVTLocal()

    ptr = open('./test/unit_test/work/input/2008_34_firefox.html', 'r')
    desc = ptr.read()
    ptr.close
    import re
    desc = re.findall('(?s)1\) Problem Description and Brief Discussion(.*)2\) Solution', desc)[0]

    def test_generateReleaseCheck(self):
        print "\nTesting Generate Script Test Suite ..."
        req_out_put = '\nif(release == "openSUSE10.2")\n{\n'

        release = 'openSUSE10.2'
        out_put = self.generate_obj.generateReleaseCheck(release)
        self.assertEquals(out_put, req_out_put)


    def test_generateClose(self):
        req_out_put = '\n  exit(0);\n}\n'

        out_put = self.generate_obj.generateClose()
        self.assertEquals(out_put, req_out_put)


    def test_generateRPMCheck(self):
        req_out_put = '\n  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"SLE SDK 10 SP1"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"SLE SDK 10 SP1"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n'

        Packages = {'SLE SDK 10 SP1' : ['pcre-devel-6.4-14.12','pcre-6.4-14.12'] }
        platform = 'SLE SDK 10 SP1'
        setattr(generate_script.GenerateCode, 'Packages', Packages)
        out_put = self.generate_obj.generateRPMCheck(self.generate_obj, platform)
        self.assertEquals(out_put, req_out_put)


    def test_generateDebPkgCheck(self):
        req_out_put = '\n  if(isrpmvuln(pkg:"libgnutls13-dbg", rpm:"libgnutls13-dbg~1.4.4~3+etch4", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"libgnutls13", rpm:"libgnutls13~1.4.4~3+etch4", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"gnutls-bin", rpm:"gnutls-bin~1.4.4~3+etch4", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"libgnutls-dev", rpm:"libgnutls-dev~1.4.4~3+etch4", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"libgnutls26-dbg", rpm:"libgnutls26-dbg~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"libgnutls-dev", rpm:"libgnutls-dev~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"libgnutls26", rpm:"libgnutls26~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"guile-gnutls", rpm:"guile-gnutls~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"gnutls-bin", rpm:"gnutls-bin~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"gnutls-doc", rpm:"gnutls-doc~1.4.4~3+etch4", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"gnutls-doc", rpm:"gnutls-doc~2.4.2~6+lenny1", rls:"DEB4.0"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n'

        Packages = {'DEB4.0': ['libgnutls13-dbg_1.4.4-3+etch4', 'libgnutls13_1.4.4-3+etch4', 'gnutls-bin_1.4.4-3+etch4', 'libgnutls-dev_1.4.4-3+etch4', 'libgnutls26-dbg_2.4.2-6+lenny1', 'libgnutls-dev_2.4.2-6+lenny1', 'libgnutls26_2.4.2-6+lenny1', 'guile-gnutls_2.4.2-6+lenny1', 'gnutls-bin_2.4.2-6+lenny1', 'gnutls-doc_1.4.4-3+etch4', 'gnutls-doc_2.4.2-6+lenny1']}
        platform = 'DEB4.0'
        setattr(generate_script.GenerateCode, 'Packages', Packages)
        out_put = self.generate_obj.generateRPMCheck(self.generate_obj, platform)
        self.assertEquals(out_put, req_out_put)


    def test_truncateDescription(self):
        req_out_put = '\n\n   Mozilla Firefox was updated to version 2.0.0.15, fixing various bugs\n   including following security bugs.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2798">CVE-2008-2798</a> <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2799">CVE-2008-2799</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-21.html">MFSA 2008-21</a>:\n   Mozilla developers identified and fixed several stability bugs in the\n   browser engine used in Firefox and other Mozilla-based products. Some\n   of these crashes showed evidence of memory corruption under certain\n   circumstances and we presume that with enough effort at least some\n   of these could be exploited to run arbitrary code.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2800">CVE-2008-2800</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-22.html">MFSA 2008-22</a>:\n   Mozilla contributor moz_bug_r_a4 submitted a set of vulnerabilities\n   which allow scripts from one document to be executed in the context\n   of a different document. These vulnerabilities could be used by an\n   attacker to violate the same-origin policy and perform an XSS attack.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2801">CVE-2008-2801</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-23.html">MFSA 2008-23</a>:\n   Security researcher Collin Jackson reported a series of vulnerabilities\n   which allow JavaScript to be injected into signed JARs and executed\n   under the context of the JAR\'s signer. This could allow an attacker\n   to run JavaScript in a victim\'s browser with the privileges of a\n   different website, provided the attacker possesses a JAR signed by\n   the other website.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2802">CVE-2008-2802</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-24.html">MFSA 2008-24</a>:\n   Mozilla contributor moz_bug_r_a4 reported a vulnerability that\n   allowed non-privileged XUL documents to load chrome scripts from\n   the fastload file.  This could allow an attacker to run arbitrary\n   JavaScript code with chrome privileges.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2803">CVE-2008-2803</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-25.html">MFSA 2008-25</a>:\n   Mozilla contributor moz_bug_r_a4 reported a vulnerability which allows\n   arbitrary JavaScript to be executed with chrome privileges. The\n   privilege escalation was possible because JavaScript loaded via\n   mozIJSSubScriptLoader.loadSubScript() was no ... \n\n  Description truncated, for more information please check the Reference URL'

        setattr(generate_script.GenerateNVTLocal, 'parse', self.gen_nvt_obj)
        setattr(generate_script.GenerateNVTLocal, 'Description', self.desc)
        setattr(generate_script.GenerateNVTLocal, 'Impact', 'My Unit Test Impact')
        setattr(generate_script.GenerateNVTLocal, 'Platforms', 'SLE SDK 10 SP1')
        setattr(generate_script.GenerateNVTLocal, 'Product', 'Fire Fox')
        out_put = self.gen_nvt_obj._truncateDescription(self.desc)
        self.assertEquals(out_put, req_out_put)


    def test_generateCode(self):
        req_out_put = '###############################################################################\n# OpenVAS Vulnerability Test\n#\n# SuSE Update for Fire Fox CVE-10101\n#\n# Authors:\n# System Generated Check\n#\n# Copyright:\n# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net\n#\n# This program is free software; you can redistribute it and/or modify\n# it under the terms of the GNU General Public License version 2\n# (or any later version), as published by the Free Software Foundation.\n#\n# This program is distributed in the hope that it will be useful,\n# but WITHOUT ANY WARRANTY; without even the implied warranty of\n# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n# GNU General Public License for more details.\n#\n# You should have received a copy of the GNU General Public License\n# along with this program; if not, write to the Free Software\n# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.\n###############################################################################\n\nif(description)\n{\n  script_id(10000);\n  script_version("$Revision: 1.0 $");\n  script_xref(name: "S", value: "U");\n  script_cve_id("CVE-10101");\n  script_name(english: "SuSE Update for Fire Fox CVE-10101");\n  desc["english"] = "\n\n  Vulnerability Insight:\n\n\n   Mozilla Firefox was updated to version 2.0.0.15, fixing various bugs\n   including following security bugs.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2798">CVE-2008-2798</a> <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2799">CVE-2008-2799</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-21.html">MFSA 2008-21</a>:\n   Mozilla developers identified and fixed several stability bugs in the\n   browser engine used in Firefox and other Mozilla-based products. Some\n   of these crashes showed evidence of memory corruption under certain\n   circumstances and we presume that with enough effort at least some\n   of these could be exploited to run arbitrary code.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2800">CVE-2008-2800</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-22.html">MFSA 2008-22</a>:\n   Mozilla contributor moz_bug_r_a4 submitted a set of vulnerabilities\n   which allow scripts from one document to be executed in the context\n   of a different document. These vulnerabilities could be used by an\n   attacker to violate the same-origin policy and perform an XSS attack.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2801">CVE-2008-2801</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-23.html">MFSA 2008-23</a>:\n   Security researcher Collin Jackson reported a series of vulnerabilities\n   which allow JavaScript to be injected into signed JARs and executed\n   under the context of the JAR\'s signer. This could allow an attacker\n   to run JavaScript in a victim\'s browser with the privileges of a\n   different website, provided the attacker possesses a JAR signed by\n   the other website.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2802">CVE-2008-2802</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-24.html">MFSA 2008-24</a>:\n   Mozilla contributor moz_bug_r_a4 reported a vulnerability that\n   allowed non-privileged XUL documents to load chrome scripts from\n   the fastload file.  This could allow an attacker to run arbitrary\n   JavaScript code with chrome privileges.\n\n   <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2803">CVE-2008-2803</a> <a href="http://www.mozilla.org/security/announce/2008/mfsa2008-25.html">MFSA 2008-25</a>:\n   Mozilla contributor moz_bug_r_a4 reported a vulnerability which allows\n   arbitrary JavaScript to be executed with chrome privileges. The\n   privilege escalation was possible because JavaScript loaded via\n   mozIJSSubScriptLoader.loadSubScript() was no ... \n\n  Description truncated, for more information please check the Reference URL\n\n  Impact:\n  My Unit Test Impact\n\n  Affected Software/OS:\n  Fire Fox on SLE SDK 10 SP1\n\n  Fix: Please Install the Updated Packages.\n\n  References:\n  http://www.novell.com/linux/security/advisories/2008_34_firefox.html\n\n  Risk factor: High";\n\n  script_description(english:desc["english"]);\n  script_summary(english:"Check for the Version of My Unit Test Summary");\n  script_category(ACT_GATHER_INFO);\n  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");\n  script_family(english:"SuSE Local Security Checks");\n  script_dependencies("gather-package-list.nasl");\n  script_require_keys("ssh/login/release");\n  exit(0);\n}\n\n\ninclude("pkg-lib-rpm.inc");\ninclude("revisions-lib.inc");\n\nrelease = get_kb_item("ssh/login/release");\n\nif(release == NULL){\n  exit(0);\n}\n\nif(release == "SLE SDK 10 SP1")\n{\n\n  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"SLE SDK 10 SP1"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"SLE SDK 10 SP1"))\n  {\n    security_hole(0);\n    exit(0);\n  }\n\n  exit(0);\n}'

        ptr = open('./test/unit_test/work/input/Suse.template', 'r')
        template = ptr.read()
        ptr.close()
        script_id = '10000'
        reference = 'http://www.novell.com/linux/security/advisories/2008_34_firefox.html'

        Packages = {'SLE SDK 10 SP1' : ['pcre-devel-6.4-14.12','pcre-6.4-14.12'] }
        platform = 'SLE SDK 10 SP1'
        setattr(generate_script.GenerateNVTLocal, 'parse', self.gen_nvt_obj)
        setattr(generate_script.GenerateNVTLocal, 'Packages', Packages)
        setattr(generate_script.GenerateNVTLocal, 'Description', self.desc)
        setattr(generate_script.GenerateNVTLocal, 'CVEs', 'CVE-10101')
        setattr(generate_script.GenerateNVTLocal, 'Impact', 'My Unit Test Impact')
        setattr(generate_script.GenerateNVTLocal, 'Platforms', 'SLE SDK 10 SP1')
        setattr(generate_script.GenerateNVTLocal, 'Product', 'Fire Fox')
        setattr(generate_script.GenerateNVTLocal, 'Name', 'Fire Fox CVE-10101')
        setattr(generate_script.GenerateNVTLocal, 'XREF', 'SUSE-SA-2008-034')
        setattr(generate_script.GenerateNVTLocal, 'Summary', 'My Unit Test Summary')
        out_put = self.gen_nvt_obj.generateCode(template, script_id, reference)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()
