###############################################################################
# OpenVAS Vulnerability Test
# $Id: DHCart_multiple_xss.nasl 99 2009-03-07 14:21:58Z mime $
#
# DHCart Multiple Cross Site Scripting And HTML Injection
# Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100028);
 script_bugtraq_id(32117);
 script_cve_id("CVE-2008-6297");
 script_version ("1.0");

 script_name(english:"DHCart Multiple Cross Site Scripting And HTML Injection Vulnerabilities");
 desc["english"] = "

 Overview:
  DHCart is prone to multiple cross-site scripting and HTML-injection
  vulnerabilities because it fails to sufficiently sanitize
  user-supplied data.

  Attacker-supplied HTML or JavaScript code could run in the context
  of the affected site, potentially allowing the attacker to steal
  cookie-based authentication credentials and to control how the site
  is rendered to the user; other attacks are also possible.

  DHCart 3.84 is vulnerable; other versions may also be affected. 

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if DHCart is prone to multiple  Cross Site Scripting And HTML Injection vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list(cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/order.php?dhaction=check&submit_domain=Register&domain=<script>alert(document.cookie);</script>&ext1=on");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if (
     ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 .*", string:buf) &&
     egrep(pattern:"<script>alert\(document\.cookie\);</script>", string: buf) 
    )
     
 	{    
       	  security_warning(port:port);
          exit(0);
        }
}

exit(0);
