###############################################################################
# OpenVAS Vulnerability Test
# $Id: OpenVAS_detect.nasl 2889 2009-03-24 17:59:36Z mime $
#
# OpenVAS Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100076);
 script_version ("1.0");
 
 name["english"] = "OpenVAS Detection";
 script_name(english:name["english"]);
 
 desc["english"] = "
  Overview:
   
   OpenVAS is running at this host.

   OpenVAS stands for Open Vulnerability Assessment System and is a network
   security scanner with associated tools like a graphical user front-end. The
   core component is a server with a set of network vulnerability tests (NVTs) to
   detect security problems in remote systems and applications. 
   See http://openvas.org for more information.

Risk factor : None";

 script_description(english:desc["english"]);
 summary["english"] = "A OpenVAS Daemon is running";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_family(english:"Service detection");
 script_require_ports(9390);
 script_dependencies("find_service2.nasl");
 exit(0);
}

include("misc_func.inc");
  
function probe(port)
{
  soc = open_sock_tcp(port, transport:ENCAPS_SSLv23);
  if (soc) {
    for(count=0; count < 3 ; count++)
    {
     senddata = string("< OTP/1.", count, " >\n");
     send(socket:soc, data:senddata);
     recvdata = recv_line(socket:soc, length:20);
     if (ereg(pattern:"^< OTP/1." + count + " >$",string:recvdata)) {
	close(soc);
	security_note(port:port);
	register_service(port: port, proto: "OpenVAS");
	break;
     }  	
    }
  }
}

port = get_kb_item("Services/unknown");

if(port)
{
 if (known_service(port: port)) exit(0); 
 if(get_port_state(port))
  probe(port:port);
}
else
{
 if(get_port_state(9390))
  probe(port:9390);
}

exit(0);
