# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0003 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63109);
 script_cve_id("CVE-2008-4405", "CVE-2008-4993");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0003";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0003.

The xen packages contain the Xen tools and management daemons needed to
manage virtual machines running on Red Hat Enterprise Linux.

Xen was found to allow unprivileged DomU domains to overwrite xenstore
values which should only be changeable by the privileged Dom0 domain. An
attacker controlling a DomU domain could, potentially, use this flaw to
kill arbitrary processes in Dom0 or trick a Dom0 user into accessing the
text console of a different domain running on the same host. This update
makes certain parts of the xenstore tree read-only to the unprivileged DomU
domains. (CVE-2008-4405)

It was discovered that the qemu-dm.debug script created a temporary file in
/tmp in an insecure way. A local attacker in Dom0 could, potentially, use
this flaw to overwrite arbitrary files via a symlink attack. Note: This
script is not needed in production deployments and therefore was removed
and is not shipped with updated xen packages. (CVE-2008-4993)

This update also fixes the following bug:

* xen calculates its running time by adding the hypervisor's up-time to the
hypervisor's boot-time record. In live migrations of para-virtualized
guests, however, the guest would over-write the new hypervisor's boot-time
record with the boot-time of the previous hypervisor. This caused
time-dependent processes on the guests to fail (for example, crond would
fail to start cron jobs). With this update, the new hypervisor's boot-time
record is no longer over-written during live migrations.

All xen users are advised to upgrade to these updated packages, which
contain backported patches to resolve these issues. The Xen host must be
restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0003.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0003";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xen-debuginfo", rpm:"xen-debuginfo~3.0.3~64.el5_2.9", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xen-libs", rpm:"xen-libs~3.0.3~64.el5_2.9", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xen", rpm:"xen~3.0.3~64.el5_2.9", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xen-devel", rpm:"xen-devel~3.0.3~64.el5_2.9", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
