# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0053 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63317);
 script_cve_id("CVE-2008-5079", "CVE-2008-5134", "CVE-2008-5182", "CVE-2008-5300", "CVE-2008-5700", "CVE-2009-0065");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0053";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing kernel updates announced in
advisory RHSA-2009:0053.

These updated packages address the following security issues:

* a flaw was found in the Asynchronous Transfer Mode (ATM) subsystem. A
local, unprivileged user could use the flaw to listen on the same socket
more than once, possibly causing a denial of service. (CVE-2008-5079,
Important)

* a buffer overflow flaw was found in the libertas driver. This could,
potentially, lead to a remote denial of service when an invalid beacon or
probe response was received. (CVE-2008-5134, Important)

* a race condition was found in the Linux kernel inotify watch removal
and umount implementation. This could allow a local, unprivileged user
to cause a privilege escalation or a denial of service. (CVE-2008-5182,
Important)

* the sendmsg() function in the Linux kernel did not block during UNIX
socket garbage collection. This could, potentially, lead to a local denial
of service. (CVE-2008-5300, Important)

* a buffer overflow was found in the Linux kernel Partial Reliable Stream
Control Transmission Protocol (PR-SCTP) implementation. This could,
potentially, lead to a denial of service if a Forward-TSN chunk is received
with a large stream ID. (CVE-2009-0065, Important)

* a deficiency was found in the libATA implementation. This could,
potentially, lead to a denial of service. By default, the /dev/sg*
devices are accessible only to the root user. (CVE-2008-5700, Low)

For further details on other bugs fixed, please visit the referenced
security advisories.

All Red Hat Enterprise MRG users should install this update which addresses
these vulnerabilities and fixes these bugs. For this update to take effect,
the system must be rebooted.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0053.html
http://www.redhat.com/security/updates/classification/#important
http://www.redhat.com/docs/en-US/Red_Hat_Enterprise_MRG/1.1/html/MRG_Release_Notes/

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0053";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug", rpm:"kernel-rt-debug~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-debuginfo", rpm:"kernel-rt-debug-debuginfo~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-devel", rpm:"kernel-rt-debug-devel~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo", rpm:"kernel-rt-debuginfo~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo-common", rpm:"kernel-rt-debuginfo-common~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-devel", rpm:"kernel-rt-devel~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace", rpm:"kernel-rt-trace~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-debuginfo", rpm:"kernel-rt-trace-debuginfo~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-devel", rpm:"kernel-rt-trace-devel~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla", rpm:"kernel-rt-vanilla~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-debuginfo", rpm:"kernel-rt-vanilla-debuginfo~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-devel", rpm:"kernel-rt-vanilla-devel~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-doc", rpm:"kernel-rt-doc~2.6.24.7~101.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
