# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0225 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63249);
 script_cve_id("CVE-2008-5029", "CVE-2008-5079", "CVE-2008-5182");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0225";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:0225.

These updated packages contain 730 bug fixes and enhancements for the Linux
kernel. Space precludes a detailed description of each of these changes in
this advisory and users are therefore directed to the release notes for Red
Hat Enterprise Linux 5.3 for information on 97 of the most significant of
these changes.

Details of three security-related bug fixes are set out below, along with
notes on other broad categories of change not covered in the release notes.
For more detailed information on specific bug fixes or enhancements, please
consult the Bugzilla numbers listed in this advisory.

* when fput() was called to close a socket, the __scm_destroy() function
in the Linux kernel could make indirect recursive calls to itself. This
could, potentially, lead to a denial of service issue. (CVE-2008-5029,
Important)

* a flaw was found in the Asynchronous Transfer Mode (ATM) subsystem. A
local, unprivileged user could use the flaw to listen on the same socket
more than once, possibly causing a denial of service. (CVE-2008-5079,
Important)

* a race condition was found in the Linux kernel inotify watch removal
and umount implementation. This could allow a local, unprivileged user
to cause a privilege escalation or a denial of service. (CVE-2008-5182,
Important)

All users are advised to upgrade to these updated packages, which resolve
these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0225.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0225";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-debuginfo", rpm:"kernel-kdump-debuginfo~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-devel", rpm:"kernel-kdump-devel~2.6.18~128.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
