# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0275 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63419);
 script_cve_id("CVE-2008-5005");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0275";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0275.

The imap package provides server daemons for both the IMAP (Internet
Message Access Protocol) and POP (Post Office Protocol) mail access protocols.

A buffer overflow flaw was discovered in the dmail and tmail mail delivery
utilities shipped with imap. If either of these utilities were used as a
mail delivery agent, a remote attacker could potentially use this flaw to
run arbitrary code as the targeted user by sending a specially-crafted mail
message to the victim. (CVE-2008-5005)

Users of imap should upgrade to these updated packages, which contain a
backported patch to resolve this issue.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0275.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0275";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"imap", rpm:"imap~2002d~15", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-debuginfo", rpm:"imap-debuginfo~2002d~15", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-devel", rpm:"imap-devel~2002d~15", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-utils", rpm:"imap-utils~2002d~15", rls:"RHENT_3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
