# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0345 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63585);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0345";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0345.

Ghostscript is a set of software that provides a PostScript(TM)
interpreter, a set of C procedures (the Ghostscript library, which
implements the graphics capabilities in the PostScript language) and
an interpreter for Portable Document Format (PDF) files.

Multiple integer overflow flaws which could lead to heap-based buffer
overflows, as well as multiple insufficient input validation flaws, were
found in Ghostscript's International Color Consortium Format library
(icclib). Using specially-crafted ICC profiles, an attacker could create a
malicious PostScript or PDF file with embedded images which could cause
Ghostscript to crash, or, potentially, execute arbitrary code when opened
by the victim. (CVE-2009-0583, CVE-2009-0584)

All users of ghostscript are advised to upgrade to these updated packages,
which contain a backported patch to correct these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0345.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0345";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.05~32.1.17", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.05~32.1.17", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.05~32.1.17", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.3~32.1.17", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.07~33.2.el4_7.5", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.07~33.2.el4_7.5", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.07~33.2.el4_7.5", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~7.07~33.2.el4_7.5", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.15.2~9.4.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~8.15.2~9.4.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~8.15.2~9.4.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.15.2~9.4.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
