# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0457 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63909);
 script_cve_id("CVE-2009-1364");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0457";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0457.

libwmf is a library for reading and converting Windows Metafile Format
(WMF) vector graphics. libwmf is used by applications such as GIMP and
ImageMagick.

A pointer use-after-free flaw was found in the GD graphics library embedded
in libwmf. An attacker could create a specially-crafted WMF file that would
cause an application using libwmf to crash or, potentially, execute
arbitrary code as the user running the application when opened by a victim.
(CVE-2009-1364)

Note: This flaw is specific to the GD graphics library embedded in libwmf.
It does not affect the GD graphics library from the gd packages, or
applications using it.

Red Hat would like to thank Tavis Ormandy of the Google Security Team for
responsibly reporting this flaw.

All users of libwmf are advised to upgrade to these updated packages, which
contain a backported patch to correct this issue. After installing the
update, all applications using libwmf must be restarted for the update
to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0457.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0457";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libwmf", rpm:"libwmf~0.2.8.3~5.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-debuginfo", rpm:"libwmf-debuginfo~0.2.8.3~5.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-devel", rpm:"libwmf-devel~0.2.8.3~5.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf", rpm:"libwmf~0.2.8.4~10.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-debuginfo", rpm:"libwmf-debuginfo~0.2.8.4~10.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-devel", rpm:"libwmf-devel~0.2.8.4~10.2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
