# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:1040 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63982);
 script_cve_id("CVE-2009-0159", "CVE-2009-1252");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:1040";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:1040.

The Network Time Protocol (NTP) is used to synchronize a computer's time
with a referenced time source.

A buffer overflow flaw was discovered in the ntpd daemon's NTPv4
authentication code. If ntpd was configured to use public key cryptography
for NTP packet authentication, a remote attacker could use this flaw to
send a specially-crafted request packet that could crash ntpd or,
potentially, execute arbitrary code with the privileges of the ntp user.
(CVE-2009-1252)

Note: NTP authentication is not enabled by default.

A buffer overflow flaw was found in the ntpq diagnostic command. A
malicious, remote server could send a specially-crafted reply to an ntpq
request that could crash ntpq or, potentially, execute arbitrary code with
the privileges of the user running the ntpq command. (CVE-2009-0159)

All ntp users are advised to upgrade to this updated package, which
contains backported patches to resolve these issues. After installing the
update, the ntpd daemon will be restarted automatically.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-1040.html
http://www.redhat.com/security/updates/classification/#critical

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:1040";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.0.a.20040617~8.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-debuginfo", rpm:"ntp-debuginfo~4.2.0.a.20040617~8.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
