##############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Apache Web Server Linefeed Memory Allocation Denial Of Service
# Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100171);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2003-0132");
  script_bugtraq_id(7254);
  script_name(english:"Apache Web Server Linefeed Memory Allocation Denial Of Service Vulnerability");
  desc["english"] = "

  Overview:
   Apache 2.0 series webservers are prone to a denial-of-service
   condition. This issue occurs because of the way that Apache handles
   excessive amounts of consecutive linefeed characters. The server
   may allocate large amounts of memory, resulting in a denial of
   service. 

  Solution:
   This vulnerability does not affect Apache 2.0.45. Users are advised to upgrade.

  See also:
   http://www.securityfocus.com/bid/7254
   http://httpd.apache.org/

  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Apache Web Server version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_family(english:"Web application abuses");
  script_dependencies("http_version.nasl", "secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

version = get_kb_item("www/" + httpdPort + "/Apache");
if(version != NULL){
  if(version_is_less(version:version, test_version:"2.0.45")){
    security_warning(httpdPort);
  }
}
