# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1019-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56470);
 script_cve_id("CVE-2006-1244");
 script_bugtraq_id(16748);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1019-1 (koffice)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to koffice
announced via advisory DSA 1019-1.

Derek Noonburg has fixed several potential vulnerabilities in xpdf,
the Portable Document Format (PDF) suite, which is also present in
koffice, the KDE Office Suite.

The old stable distribution (woody) does not contain kpdf packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.3.5-4.sarge.3.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your kpdf package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201019-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1019-1 (koffice)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kivio-data", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-data", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"karbon", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kchart", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kformula", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kivio", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-dev", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-libs", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koshell", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpresenter", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kspread", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kugar", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kword", ver:"1.3.5-4.sarge.3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
