# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 107-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53763);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 107-1 (jgroff)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to jgroff
announced via advisory DSA 107-1.

Basically, this is the same Security Advisory as DSA 072-1, but for
jgroff instead of groff.  The package jgroff contains a version
derived from groff that has japaneze character sets enabled.  This
package is available only in the stable release of Debian, patches for
japanese support have been merged into the main groff package.

The old advisory said:

Zenith Parse found a security problem in groff (the GNU version of
troff).  The pic command was vulnerable to a printf format attack
which made it possible to circumvent the `-S' option and execute
arbitrary code.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20107-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 107-1 (jgroff)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"jgroff", ver:"1.15+ja-3.4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
