# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1127-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57164);
 script_cve_id("CVE-2006-3628", "CVE-2006-3629", "CVE-2006-3630", "CVE-2006-3631", "CVE-2006-3632");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1127-1 (ethereal)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ethereal
announced via advisory DSA 1127-1.

Several remote vulnerabilities have been discovered in the Ethereal network
sniffer, which may lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2006-3628

Ilja van Sprundel discovered that the FW-1 and MQ dissectors are
vulnerable to format string attacks.

CVE-2006-3629

Ilja van Sprundel discovered that the MOUNT dissector is vulnerable
to denial of service through memory exhaustion.

CVE-2006-3630

Ilja van Sprundel discovered off-by-one overflows in the NCP NMAS and
NDPS dissectors.

CVE-2006-3631

Ilja van Sprundel discovered a buffer overflow in the NFS dissector.

CVE-2006-3632

Ilja van Sprundel discovered that the SSH dissector is vulnerable
to denial of service through an infinite loop.

For the stable distribution (sarge) these problems have been fixed in
version 0.10.10-2sarge6.

For the unstable distribution (sid) these problems have been fixed in
version 0.99.2-1 of wireshark, the sniffer formerly known as ethereal.

We recommend that you upgrade your ethereal packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201127-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1127-1 (ethereal)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.10.10-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.10.10-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.10.10-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.10.10-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
