# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1344-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58516);
 script_cve_id("CVE-2007-3844", "CVE-2007-3845");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1344-1 (iceweasel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to iceweasel
announced via advisory DSA 1344-1.

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-3844

moz_bug_r_a4 discovered that a regression in the handling of
about:blank windows used by addons may lead to an attacker being
able to modify the content of web sites.

CVE-2007-3845

Jesper Johansson discovered that missing sanitising of double-quotes
and spaces in URIs passed to external programs may allow an attacker
to pass arbitrary arguments to the helper program if the user is
tricked into opening a malformed web page.

The Mozilla products in the oldstable distribution (sarge) are no longer
supported with with security updates.

For the stable distribution (etch) these problems have been fixed in version
2.0.0.6-0etch1.

For the unstable distribution (sid) these problems have been fixed in version
2.0.0.6-1.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201344-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1344-1 (iceweasel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
