# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1365-3
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58638);
 script_cve_id("CVE-2007-4460");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1365-3 (id3lib3.8.3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to id3lib3.8.3
announced via advisory DSA 1365-3.

Nikolaus Schulz discovered that a programming error in id3lib, an ID3 Tag
Library, may lead to denial of service through symlink attacks.

This update to DSA-1365-2 provides missing packages for the mipsel
architecture for the stable distribution (etch).

For the oldstable distribution (sarge) this problem has been fixed in
version 3.8.3-4.1sarge1.

For the stable distribution (etch) this problem has been fixed in
version 3.8.3-6etch1.

For the unstable distribution (sid) this problem has been fixed in
version 3.8.3-7.

We recommend that you upgrade your id3lib3.8.3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201365-3

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1365-3 (id3lib3.8.3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libid3-3.8.3", ver:"3.8.3-4.1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libid3-3.8.3-dev", ver:"3.8.3-4.1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libid3-3.8.3-dev", ver:"3.8.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libid3-3.8.3c2a", ver:"3.8.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
